﻿
function Show-DynamicMenu
{
  [CmdletBinding()]
  Param
  (
    [Parameter(Mandatory=$true,Position=0)]
    [ValidateNotNullOrEmpty()]
    $objArr
  )
 
  $count = 1
  $total = ($objArr | measure).count
 
  if($total -eq 1){return $objArr} #I knew you would do it; thank me later
  
  $menuHash = @{}
  $objArr | % {$menuHash[$count] = $_;$count++}
  
  $pad = $total.ToString().Length
  1..$total | % {Write-Host "  "$($_.ToString().PadLeft($pad) + " -> " + $menuHash[$_])} #display menu selections
  do
  {
    do
    {
      $selection = $null
      $default = $menuHash[[int]1]
      $selection = Read-Host "   Auswahl: [$default], 0=Abbruch"
      if($selection -eq 0){return $null}
      if($selection -eq "" ){return $menuHash[[int]1]}
    }
    while($selection -notmatch '^\d+$') #validate numeric only entry
  }
  while([int]$selection -lt 1 -or [int]$selection -gt $total) #validate numeric entry is in range
 
  $menuHash[[int]$selection]
}
