﻿clear
$CreoMainVersion = "10"
Write-Host "============================================================"
Write-Host " Konfiguration HKA Creo $CreoMainVersion"
Write-Host "============================================================"
Import-Module -force $PSScriptRoot\F_Show-DynamicMenu.psm1
# -------------------------------------------------------------------
# Ort und Vollständigkeit der Konfiguration prüfen
# -------------------------------------------------------------------
$HKA_Config = $env:HKA_root #$PSScriptRoot
Write-Host "Speicherort für HKA Konfiguration prüfen:" -ForegroundColor Cyan
Write-Host "   Ort: $HKA_CONFIG .. " -noNewLine

if ( $HKA_Config -match "Program Files" ){
    write-Host " .. FEHLER" -ForegroundColor "red"
    Write-Host "   Eine Installation unter `"Programme`" ist nicht möglich!  " -ForegroundColor DarkRed -BackgroundColor Yellow
    Write-Host "ABBRUCH" -ForegroundColor Red
    exit
    }

if ( $HKA_Config -match "Desktop" ){
    write-Host " .. FEHLER" -ForegroundColor "red"
    Write-Host "   Eine Installation auf dem Desktop ist nicht möglich!   " -ForegroundColor DarkRed -BackgroundColor Yellow
    Write-Host "ABBRUCH" -ForegroundColor Red
    exit
    }
Write-Host "OK" -ForegroundColor Green

Write-Host "   Ordner Einstellungen .. " -noNewline
if (-not (Test-Path "$HKA_Config\Einstellungen")){
    Write-Host "Nicht gefunden!" -ForegroundColor Red
    exit
}
Write-Host "gefunden" -ForegroundColor Green

Write-Host "   Ordner Lib .. " -noNewline
if (-not (Test-Path "$HKA_Config\Lib")){
    Write-Host "Nicht gefunden!" -ForegroundColor Red
    exit
}
Write-Host "gefunden" -ForegroundColor Green

Write-Host "   Ordner SystemColor .. " -noNewline
if (-not (Test-Path "$HKA_Config\SystemColor")){
    Write-Host "Nicht gefunden!" -ForegroundColor Red
    exit
}
Write-Host "gefunden" -ForegroundColor Green
Write-Host " "

# -------------------------------------------------------------------
# Creo Installation suchen
# -------------------------------------------------------------------
Write-Host "Creo $CreoMainVersion Installation suchen:" -ForegroundColor Cyan
if ([array]$files = @(Get-ChildItem -Name -Directory -Path "C:\Program Files\PTC\Creo $CreoMainVersion*")| sort -Descending){
    $CreoVersion = $files[0]
    $CreoInstallPath="C:\Program Files\PTC\$CreoVersion"
    Write-Host "   $CreoInstallPath .. " -noNewLine 
    Write-Host " OK" -ForegroundColor Green
} else {
    Write-Host "   Kein Creo $CreoMainVersion gefunden .. " -NoNewLine 
    Write-Host "   FEHLER" -ForegroundColor Red
    Write-Host "   Bitte ZUERST Creo $CreoMainVersion installieren!" -ForegroundColor DarkRed -BackgroundColor Yellow
    exit
}
Write-Host " "

# -------------------------------------------------------------------
# Creo Sprache einstellen
# -------------------------------------------------------------------
# CreoLang
[array]$resources = @(Get-ChildItem -Name -Directory -Path "$CreoInstallPath\Parametric\text\resource\*")

[array]$lang = "german","C"

foreach( $line in $resources )
    {
    if( $Line -eq "german" ){ continue }
    $lang += $line
    }

Write-Host "Sprache für Creo einstellen:" -ForegroundColor Cyan
Write-Host "      Bei einem deutschen Windows sind deutsch (german) und"     -ForegroundColor Gray
Write-Host "      englisch (C) verfügbar. Andere Sprachen sind möglich, müssen" -ForegroundColor Gray
Write-Host "      aber bei der Installation von Creo zusätzlich ausgewählt"     -ForegroundColor Gray
Write-Host "      werden.(z.B. french, italian, spanish, russian usw.)"         -ForegroundColor Gray
Write-Host "      Wenn Sie bei der nächsten Abfrage nichts eingeben, wird"      -ForegroundColor Gray
Write-Host "      german (für deutsch) benutzt."                                -ForegroundColor Gray

Write-Host " "
Write-Host "   Sprache wählen:"
Write-Host "   ----------------"

$CreoLang = Show-DynamicMenu $lang
Write-Host "   Gewählte Sprache: $CreoLang"
Write-Host " "

# -------------------------------------------------------------------
# Creo Arbeitsverzeichnis einstellen
# -------------------------------------------------------------------
Write-Host "Arbeitsverzeichnis für Creo einstellen:"                       -ForegroundColor Cyan
Write-Host "      Das Arbeitsverzeichnis ist der Ort, an dem Creo"         -ForegroundColor Gray
Write-Host "      Dateien speichert und sucht."                            -ForegroundColor Gray
Write-Host "      Wenn Sie bei der nächsten Abfrage nichts eingeben, wird" -ForegroundColor Gray
Write-Host "      der Ordner Creo10 unter Dokumente benutzt."               -ForegroundColor Gray
Write-Host "      Wenn Sie einen anderen Ort angeben wollen, müssen Sie"   -ForegroundColor Gray
Write-Host "      den vollständigen Pfad angeben. Z.B: D:\Studium\CAD"      -ForegroundColor Gray
$default = "$env:USERPROFILE\Documents\Creo10"
if (!($CreoWorkDir = Read-Host "   Arbeitsverzeichnis [Dokumente\Creo10]")) { $CreoWorkDir = $default }
Write-Host "   Arbeitsverzeichnis: $CreoWorkDir"
Write-Host " "

# -------------------------------------------------------------------
# Name der Creo Konfiguration
# -------------------------------------------------------------------
Write-Host "Startdatei für diese Konfiguration:"                       -ForegroundColor Cyan
Write-Host "      Die Startdatei dient zum Starten von Creo mit den oben"  -ForegroundColor Gray
Write-Host "      eingestellten Werten. Sie hat die Endung CMD und wird"   -ForegroundColor Gray
Write-Host "      mittels eines Doppelklicks gestartet."                   -ForegroundColor Gray
Write-Host "      Sie können mehere Startdateien anlegen, z.B. mit ver-"   -ForegroundColor Gray
Write-Host "      schiedenen Arbeitsverzeichnissen für verschiedene"       -ForegroundColor Gray
Write-Host "      Projekte oder mit unterschiedlichen Sprachen."           -ForegroundColor Gray
$default = "HKA-Creo$CreoMainVersion"
if (!($CreoCMD = Read-Host "   Name der Startdatei [$default]")) { $CreoCMD = $default }
Write-Host "   Gewählter Name: $HKA_CONFIG\$CreoCMD.cmd"

# -------------------------------------------------------------------
# Zusammenfassung
# -------------------------------------------------------------------
Write-Host " "
Write-Host "------------------------------------------------------------"             -ForegroundColor Cyan
Write-Host "Zusammenfassung:"                       -ForegroundColor Cyan
Write-Host "------------------------------------------------------------"             -ForegroundColor Cyan
Write-Host "   Creoinstallation  : $CreoInstallPath"          
Write-Host "   Sprache           : $CreoLang"                
Write-Host "   Arbeitsverzeichnis: $CreoWorkDir"          
Write-Host "   Startdatei        : $HKA_CONFIG\$CreoCMD" 
Write-Host "------------------------------------------------------------"             -ForegroundColor Cyan 
$default = "J"              
if (!($Answer = Read-Host "Startdatei anlegen (J/N) [$Default]")) { $Answer = $default }

if ( -not ($Answer -eq "J" -or $Answer -eq "Y")) {exit}

# -------------------------------------------------------------------
# Dateien anlegen
# -------------------------------------------------------------------
Write-Host "Arbeitsverzeichnis anlegen ... " -ForegroundColor Cyan -noNewLine
$status = New-Item -Path $CreoWorkDir -ItemType Directory  -ErrorAction SilentlyContinue -force
if( $status )
    { Write-Host "OK" -ForegroundColor Green } 
    else
    { Write-Host "FEHLER" -ForegroundColor DarkRed ; exit }

$TimeStamp = Get-Date -UFormat '+%Y-%m-%d %H:%M:%S'
$ConfigName="HKA_Creo" + $CreoMainVersion + "_CONFIG"
"@echo off"                                                             | Out-File -FilePath "$HKA_CONFIG\$CreoCMD.tmp" -Width 2048 
"setlocal"                                                             | Out-File -FilePath "$HKA_CONFIG\$CreoCMD.tmp" -Width 2048 -Append
"REM ============================================================"      | Out-File -FilePath "$HKA_CONFIG\$CreoCMD.tmp" -Width 2048 -Append
"REM $CreoCMD.cmd erstellt am $TimeStamp "                              | Out-File -FilePath "$HKA_CONFIG\$CreoCMD.tmp" -Width 2048 -Append
"REM ------------------------------------------------------------"      | Out-File -FilePath "$HKA_CONFIG\$CreoCMD.tmp" -Width 2048 -Append
"SET $ConfigName=$HKA_CONFIG"                                          | Out-File -FilePath "$HKA_CONFIG\$CreoCMD.tmp" -Width 2048 -Append
"SET HKA_InstDir=$CreoInstallPath"                                     | Out-File -FilePath "$HKA_CONFIG\$CreoCMD.tmp" -Width 2048 -Append
"SET HKA_WorkDir=$CreoWorkDir"                                         | Out-File -FilePath "$HKA_CONFIG\$CreoCMD.tmp" -Width 2048 -Append
"SET Lang=$CreoLang"                                                    | Out-File -FilePath "$HKA_CONFIG\$CreoCMD.tmp" -Width 2048 -Append
"REM ------------------------------------------------------------"      | Out-File -FilePath "$HKA_CONFIG\$CreoCMD.tmp" -Width 2048 -Append
Get-Content $HKA_CONFIG\$CreoCMD.tmp, $HKA_CONFIG\Einstellungen\MkConfig\CMD.template |Set-content $HKA_CONFIG\$CreoCMD.cmd
Remove-Item "*.tmp" -force